import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.Server;
import io.grpc.stub.StreamObserver;

public class HelloWorldServer {

    public static void main(String[] args) throws Exception {
        // Create a new server (on port 12345), add the service implementation to it, and start it
        Server server = Grpc.newServerBuilderForPort(12345, InsecureServerCredentials.create())
            .addService(new GreeterImpl())
            .build()
            .start();
        // Wait for the server to terminate (this will never happen in this example)
        server.awaitTermination();
    }
}

class GreeterImpl extends GreeterGrpc.GreeterImplBase {
    @Override
    public void sayHello(HelloRequest req, StreamObserver<HelloReply> resp) {
        for (int i = 1; i <= 5; i++) {
            // Read the fields 'name' and 'number' from the request message and build the greeting string
            String hello = "Hello " + req.getName() + ", " + req.getNumber() + ", " + i;
            // Build a reply message and set the value for the 'greeting' field
            HelloReply reply = HelloReply.newBuilder().setGreeting(hello).build();
            // Push the message to the client. This will call the method 'onNext()' in the client's
            // stream observer.
            resp.onNext(reply);
            // Wait for a while
            try { Thread.sleep(500); } catch (InterruptedException e) {}
        }
        // There are no more response messages. This will call the method 'onCompleted()' in the
        // client's stream observer.
        resp.onCompleted();
    }
}

