import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.Semaphore;

public class HelloWorldClient {
    public static void main(String[] args) throws Exception {
        // The semaphore notifies the main thread that it can terminate
        Semaphore finished = new Semaphore(0);
        // Create a communication channel to the server (port 12345 on the local host)
        ManagedChannel channel = Grpc.newChannelBuilder("localhost:12345", InsecureChannelCredentials.create())
            .build();
        // Create a stub for asynchronous RPCs
        GreeterGrpc.GreeterStub asyncStub = GreeterGrpc.newStub(channel);
        // Build the request message
        HelloRequest req = HelloRequest.newBuilder().setName("world").setNumber(42).build();
        // Do the asynchronous RPC. This does not return a result. Rather, we have to pass
        // a stream observer as the second argument.
        asyncStub.sayHello(req, new StreamObserver<HelloReply>() {
                // This method is called whenever the server pushes a message to the stream
                @Override
                public void onNext(HelloReply resp) {
                System.out.println(resp.getGreeting());
                }
                
                // This method is called when an exception occurred
                @Override
                public void onError(Throwable t) {
                    System.err.println("Error: " + t.getMessage());
                }

                // This method is called when the server notifies that there are no more
                // messages
                @Override
                public void onCompleted() {
                    // Release the semaphore, so the main thread can terminate
                    finished.release();
                }
            });
        
        // Wait until we get notified that the stream is completed
        finished.acquire();
        // Close the channel (i.e., the TCP connection)
        channel.shutdown();
    }
}
