import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;

public class HelloWorldClient {
    public static void main(String[] args) throws Exception {
        // Create a communication channel to the server (port 12345 on the local host)
        ManagedChannel channel = Grpc.newChannelBuilder("localhost:12345", InsecureChannelCredentials.create())
            .build();
        // Create a stub for synchronous RPCs
        GreeterGrpc.GreeterBlockingStub blockingStub = GreeterGrpc.newBlockingStub(channel);
        // Build the request message
        HelloRequest req = HelloRequest.newBuilder().setName("world").setNumber(42).build();
        // Do the RPC returning the reply message
        HelloReply resp = blockingStub.sayHello(req);
        // Get the 'greetings' field of the message and print it
        System.out.println(resp.getGreeting());
        // Close the channel (i.e., the TCP connection)
        channel.shutdown();
    }
}
